#!/usr/bin/python3
from math import *
import random
import string
import sys

from common import *
from longrandom import LongRandom

print("Content-Type: text/html")
print()

qs = os.environ.get('QUERY_STRING', None)
if not qs:
	use_lcase = use_digits = 1
	use_punct = use_ucase = 0
	passlen = 64
	length_is_bits = 1
	extra_symbols = ''
	excludes = True
else:
	form = cgi.FieldStorage()
	passlen = form_get(form, 'passlen', 12, int)
	length_is_bits = form_get(form, 'length_is_bits', 0, int)
	use_ucase = form_get(form, 'use_ucase', 0, int)
	use_lcase = form_get(form, 'use_lcase', 0, int)
	use_digits = form_get(form, 'use_digits', 0, int)
	use_punct = form_get(form, 'use_punct', 0, int)
	extra_symbols = form_get(form, 'extra_symbols', '', str)
	excludes = form_get(form, 'excludes', 0, int)

dumpfile('header.html', {'type': 'Password'})
dict = EvalDict(vars())
sys.stdout.write(open('pwform.html').read() % dict)

chars = extra_symbols
if use_lcase: chars += 'abcdefghijklmnopqrstuvwxyz'
if use_ucase: chars += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
if use_digits: chars += '0123456789'
if use_punct: chars += '~`!@#$%^&*()-_=+[]{}\\|;:,./<>?\'"'
if excludes:
    for char in '1lI0O':
        chars = chars.replace(char, '')

charbits = log(len(chars)) / log(2)
if length_is_bits:
	passlen = int(passlen // charbits + 1)
passbits = passlen * charbits

table_start()
row('Password Length', passlen)
row('Bits per character', '%.2f'%charbits)
row('Effective password bits', int(passbits))
row('Total possible combinations',
	commafy(len(chars) ** passlen))
table_end()

randval = LongRandom()

table_start()
print("<tr><th>Password</th></tr>")
for i in range(10):
	password = ''.join([ chars[randval.get(len(chars))]
						 for j in range(passlen) ])

	print("<tr><td><tt>%s</tt></td></tr>" % escape(password))

table_end()
dumpfile('footer.html')
